/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio.processors.reverb;

import sidplay.audio.processors.reverb.AllpassNetwork;
import sidplay.audio.processors.reverb.CombFilter;

public class SchroederReverb {
    private static final double COMB1DELAYMSDEF = 29.7;
    private static final double COMB2DELAYMSDEF = 37.1;
    private static final double COMB3DELAYMSDEF = 41.1;
    private static final double COMB4DELAYMSDEF = 43.7;
    private static final double ALLPASS1DELAYMSDEF = 5.0;
    private static final double ALLPASS2DELAYMSDEF = 1.7;
    private static final double ALLPASS1SUSTAINMSDEF = 96.8;
    private static final double ALLPASS2SUSTAINMSDEF = 32.9;
    private static final double SUSTAINTIMEMSDEF = 500.0;
    private static final double MIXDEF = 0.25;
    protected double mix;
    protected CombFilter comb1;
    protected CombFilter comb2;
    protected CombFilter comb3;
    protected CombFilter comb4;
    protected AllpassNetwork allpass1;
    protected AllpassNetwork allpass2;
    private double[] dBuffer = new double[1];

    public SchroederReverb(int sampleRate, int numberOfChannels, int sampleBufferSize) {
        this.comb1 = new CombFilter(sampleRate, numberOfChannels, 29.7, sampleBufferSize);
        this.comb2 = new CombFilter(sampleRate, numberOfChannels, 37.1, sampleBufferSize);
        this.comb3 = new CombFilter(sampleRate, numberOfChannels, 41.1, sampleBufferSize);
        this.comb4 = new CombFilter(sampleRate, numberOfChannels, 43.7, sampleBufferSize);
        this.allpass1 = new AllpassNetwork(sampleRate, numberOfChannels, 5.0, sampleBufferSize);
        this.allpass2 = new AllpassNetwork(sampleRate, numberOfChannels, 1.7, sampleBufferSize);
        this.comb1.setSustainTimeInMs(500.0);
        this.comb2.setSustainTimeInMs(500.0);
        this.comb3.setSustainTimeInMs(500.0);
        this.comb4.setSustainTimeInMs(500.0);
        this.allpass1.setSustainTimeInMs(96.8);
        this.allpass2.setSustainTimeInMs(32.9);
        this.mix = 0.25;
    }

    public int doReverb(short[] inBuf, int length) {
        boolean inputExhausted;
        if (length != -1) {
            this.dBuffer = new double[length];
        }
        int newLength = this.comb1.doFilter(inBuf, this.dBuffer, length);
        this.comb2.doFilter(inBuf, this.dBuffer, length);
        this.comb3.doFilter(inBuf, this.dBuffer, length);
        this.comb4.doFilter(inBuf, this.dBuffer, length);
        boolean bl = inputExhausted = newLength == -1;
        if (!inputExhausted) {
            int i = 0;
            while (i < newLength) {
                int n = i++;
                this.dBuffer[n] = this.dBuffer[n] * 0.25;
            }
        } else {
            newLength = this.dBuffer.length;
        }
        double[] dBuffer1 = new double[newLength];
        length = this.allpass1.doFilter(this.dBuffer, dBuffer1, inputExhausted ? -1 : newLength);
        length = this.allpass2.doFilter(dBuffer1, this.dBuffer, length);
        if (!inputExhausted) {
            for (int i = 0; i < length; ++i) {
                double s = (double)inBuf[i] * (1.0 - this.mix) + this.dBuffer[i] * this.mix;
                inBuf[i] = (short)Math.max(Math.min(s, 32767.0), -32768.0);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                double s = this.dBuffer[i] * this.mix;
                inBuf[i] = (short)Math.max(Math.min(s, 32767.0), -32768.0);
            }
        }
        return length;
    }
}

